-- launch daemon replacement for folder action script
-- for Mac OS 9 by Edward Mendelson
-- includes routines by John Rethorst
-- corrections, 10 June 2018
-- revised 8 October 2023 for Sonoma
-- A4 papersize, 24 August 2024
-- international printring 28 August 2024

property DELAY_TIME_SECONDS : 1.5 -- How long to wait between checking file size.

global writePDF
global openPDF
global myPlistfile
-- Sonoma
global thisFolderPosix
global myPosix
global gsPosix
global tempPosix
global pageSize

on run
	set locString to user locale of (get system info)
	if (locString is "en_US") or (locString is "en-CA") then
		set pageSize to ""
	else
		set pageSize to "-sPAPERSIZE=a4 -dFIXEDMEDIA "
	end if
	
	set myPlistfile to ""
	set myPlist to "org.wpdos.macos9"
	set myPlistfile to ((path to preferences as Unicode text) & myPlist & ".plist")
	tell application "System Events"
		try
			set dataPath to value of property list item "DataPath" of property list file myPlistfile
		on error
			-- this second try is an attempt to avoid a spurious error message under 10.6
			try
				set dataPath to value of property list item "DataPath" of property list file myPlistfile
			on error errMsg
				tell me to activate
				display dialog "Error: " & errMsg & return & return & "Could not find Unix path for SheepShaver." buttons {"OK"} giving up after 15
				error number -128
			end try
		end try
	end tell
	
	set userFldr to path to home folder as text
	set folderPath to (dataPath & ".MacOS9Transfer") as text
	-- Sonoma
	set thisFolderPosix to (POSIX path of folderPath) & "/"
	set thisFolder to POSIX file folderPath as alias
	
	--Sonoma
	set tempPosix to POSIX path of (thisFolderPosix & "temppdf.pdf")
	--Sonoma
	tell application "Finder"
		set myPath to container of (path to me) as alias
	end tell
	set myPosix to POSIX path of myPath
	set gsPosix to (myPosix & "gs")
	
	-- do shell script "echo " & gsPosix & ">~/Desktop/1.txt"
	
	tell application "Finder" to set theseItems to every item in thisFolder whose name does not end with ".file"
	
	repeat with i in theseItems
		set thisFile to i as alias
		set fileString to (thisFile as string)
		if fileString ends with ".ps" or fileString contains "TemporaryCustom" then
			set oldSize to 0
			set newSize to -1
			-- When newSize equals oldSize, the file-copy is complete because the size hasn't changed
			repeat while newSize ≠ oldSize
				-- Get the file size.
				tell application "System Events" to set oldSize to physical size of disk item fileString
				delay DELAY_TIME_SECONDS
				-- Sample the size again after delay for comparison.
				tell application "System Events" to set newSize to physical size of disk item fileString
			end repeat
			if fileString ends with "hostpdf.ps" then
				doPDF(thisFile)
			else if fileString ends with "selectprinter.ps" then
				doSelect(thisFile)
			end if
			-- with timeout of 300 seconds
			doPrint(thisFile)
			-- end timeout
		else if fileString ends with ".term" then
			doTerminal(thisFile)
		else if fileString ends with ".host" then
			doCmd(thisFile)
		else if fileString ends with ".unix" then
			doUnix(thisFile)
		else if fileString ends with ".url" then
			doURL(thisFile)
		else if fileString ends with ".tox" then
			doMove(thisFile)
		else if fileString ends with "Alert.txt" then
			convertImage(thisFile)
		else
			return
		end if
	end repeat
end run

to doURL(thisFile)
	set thisPosixItem to POSIX path of thisFile
	set openURL to (open for access POSIX file thisPosixItem)
	set theURL to (read openURL for (get eof openURL))
	close access openURL
	do shell script "rm " & quoted form of thisPosixItem
	if (theURL does not start with "http://") and (theURL does not start with "https://") then set theURL to ("http://" & theURL) as string
	open location theURL
end doURL

to doTerminal(thisFile)
	set theTerm to read thisFile
	tell application "Finder" to delete thisFile
	tell application "Terminal"
		activate
		do script (theTerm) in window 1
	end tell
end doTerminal

to doCmd(thisFile)
	set thisPosixItem to POSIX path of thisFile
	set openCmd to (open for access POSIX file thisPosixItem)
	set cmdLine to (read openCmd for (get eof openCmd))
	close access openCmd
	do shell script "rm " & quoted form of thisPosixItem
	try
		do shell script cmdLine
	on error
		-- tell me to activate
		-- display dialog "Error: Could not run command: " & return & return & cmdLine buttons {"OK"} giving up after 15
		-- return
	end try
end doCmd

to doUnix(thisFile)
	set myPlistfile to ""
	set myPlist to "org.wpdos.wpmacapp"
	set myPlistfile to ((path to preferences as Unicode text) & myPlist & ".plist")
	tell application "System Events"
		try
			set dataPath to value of property list item "DataPath" of property list file myPlistfile
		on error
			tell application "Finder" to delete thisFile
			-- tell me to activate
			-- display dialog "Error: could not find Unix path for SheepShaver." buttons {"OK"} giving up after 15
			tell application "Finder" to delete thisFile
			return
		end try
	end tell
	do shell script "open " & quoted form of dataPath
	tell application "Finder" to delete thisFile
end doUnix

to convertImage(thisFile)
	try
		set thisPosix to (POSIX path of thisFile)
		do shell script "rm -f" & space & quoted form of (thisPosix)
	end try
	try
		set unixPath to POSIX path of ((path to me as text) & "::")
		set convAppPath to unixPath & "ConvertClipboardPICT.app"
		do shell script "open" & space & quoted form of convAppPath
	on error err
		display dialog err
	end try
end convertImage

to doMove(thisFile)
	set filePOSIX to POSIX path of thisFile
	tell application "Finder"
		set thisName to name of (POSIX file filePOSIX as alias)
	end tell
	set newName to (characters 1 through -5 of thisName) as string
	set deskPosix to POSIX path of (path to desktop folder)
	set targetPosix to deskPosix & newName
	
	set moveFile to true
	set outFileExists to false
	try
		set outFileExists to do shell script "ls" & space & quoted form of targetPosix
		display dialog "A copy of this file already exists on the desktop. Do you want to overwrite it?" buttons {"Yes", "No"} default button 2
		if button returned of result is "No" then
			set moveFile to false
			do shell script "rm" & space & quoted form of filePOSIX
		end if
	end try
	
	if moveFile is true then
		try
			do shell script "mv" & space & quoted form of filePOSIX & space & quoted form of targetPosix
		on error err
			display dialog err
		end try
	end if
end doMove

to doPrint(thisFile)
	delay 0.5
	tell application "System Events"
		set folderPosix to POSIX path of container of thisFile
		set printDate to modification date of thisFile
	end tell
	
	set openText to (folderPosix & "/OpenPDF.file")
	set openPDF to false
	set writeText to (folderPosix & "/WritePDF.file")
	set writePDF to false
	
	tell application "System Events"
		try
			set infoDate to modification date of disk item openText
			set openPDF to true
		on error
			set openPDF to false
		end try
	end tell
	if openPDF is true then
		try
			set renamePS to do shell script "cat" & space & quoted form of openText
		on error
			--tell me to activate
			-- display dialog "Could not read filename."
			return
		end try
		try
			do shell script "rm" & space & quoted form of openText
		end try
		
		set newPSpath to (folderPosix & "/" & renamePS & ".ps")
		
		try
			do shell script "mv" & space & quoted form of POSIX path of thisFile & space & quoted form of newPSpath
		end try
		
		set newFile to POSIX file newPSpath as alias
		
		if infoDate - printDate is greater than 60 then
			set openPDF to false
		end if
		set userChoice to "PDF"
	end if
	
	if openPDF is false then
		tell application "System Events"
			try
				set infoDate to modification date of disk item writeText
				set writePDF to true
			on error
				set writePDF to false
			end try
		end tell
		if writePDF is true then
			try
				set renamePS to do shell script "cat" & space & quoted form of writeText
			on error
				do shell script "rm" & space & quoted form of writeText
				return
			end try
			try
				do shell script "rm" & space & quoted form of writeText
			end try
			
			set newPSpath to (folderPosix & "/" & renamePS & ".ps")
			
			try
				do shell script "mv" & space & quoted form of POSIX path of thisFile & space & quoted form of newPSpath
			end try
			
			set newFile to POSIX file newPSpath as alias
			
			if infoDate - printDate is greater than 60 then
				set writePDF to false
			end if
			set userChoice to "WritePDF"
			
		end if
	end if
	try
		set ptrCount to (do shell script "SOFTWARE= LANG=C lpstat -p | grep -c 'enabled'")
	on error errMsg
		if errMsg contains "1" then set ptrCount to 0
	end try
	
	if ptrCount is 0 then
		if writePDF is false then
			set openPDF to true
		end if
	end if
	
	if openPDF is false then
		if writePDF is false then
			set printPrompt to false
			tell application "System Events"
				try
					set printPrompt to value of property list item "printPDFprompt" of property list file myPlistfile
				on error
					set printPrompt to false
				end try
			end tell
			
			if printPrompt is "true" then
				if ptrCount is 0 then
					set dialogText to "Create a PDF from this file?" & return & return & "(No printer is available in OS X.)"
					set buttonList to {"PDF", "Cancel"}
				else
					set dialogText to "Print file or create PDF?"
					set buttonList to {"Print", "PDF", "Cancel"}
				end if
				try
					tell me to activate
					display dialog dialogText buttons buttonList default button 1 with title "Print/PDF from Mac OS 9"
					set userChoice to button returned of result
				on error
					tell application "Finder" to delete thisFile
					return
				end try
			else
				if ptrCount is 0 then
					set dialogText to "Create a PDF from this file?" & return & return & "(No printer is available in OS X/macOS.)"
					set buttonList to {"PDF", "Cancel"}
					tell me to activate
					display dialog dialogText buttons buttonList default button 1 with title "Print/PDF from Mac OS 9"
					set userChoice to button returned of result
					if userChoice is "Cancel" then
						try
							do shell script "rm " & quoted form of POSIX path of thisFile
						end try
					end if
				else
					set userChoice to "Print"
				end if
			end if
		end if
	end if
	
	-- is this routine needed at all??
	tell application "System Events"
		set thisItem to disk item (thisFile as text)
		set |then| to thisItem's modification date
		delay 0.3
		set now to thisItem's modification date
		repeat while (now comes after |then|)
			delay 0.3
			set |then| to now
			set now to thisItem's modification date
		end repeat
	end tell
	
	-- Sonoma
	try
		do shell script quoted form of gsPosix & space & pageSize & "-sBATCH -dNOPAUSE -sDEVICE=pdfwrite -sOutputFile=" & quoted form of tempPosix & space & quoted form of POSIX path of thisFile
	on error err
		display dialog err
	end try
	
	if userChoice = "Print" then
		-- Sonoma
		do shell script "lpr -r" & space & quoted form of tempPosix
		do shell script "rm " & quoted form of POSIX path of thisFile
	else if userChoice = "PDF" then
		-- tell application "Finder" to open thisFile
		try
			--Sonoma
			tell application "Finder" to open POSIX file tempPosix
		on error err
			activate
			display dialog err
		end try
		delay 2 -- added to avoid deleting file before converted
		tell application "System Events"
			repeat until busy status of thisFile is false
				delay 1
			end repeat
		end tell
		-Sonoma
		do shell script "rm" & space & quoted form of tempPosix
	else if userChoice = "WritePDF" then
		set outputName to (renamePS & ".pdf") as string
		set deskPosix to POSIX path of (path to desktop folder)
		set outputPath to deskPosix & outputName
		
		--Sonoma 
		try
			do shell script quoted form of gsPosix & space & pageSize & "-sBATCH -dNOPAUSE -sDEVICE=pdfwrite -sOutputFile=" & quoted form of outputPath & space & quoted form of POSIX path of thisFile
		on error err
			display dialog err
		end try
		--Sonoma fix
		-- do shell script ("pstopdf -o " & quoted form of outputPath & space & quoted form of POSIX path of thisFile)
		-- do shell script ("mv" & space & quoted form of tempPosix & space & quoted form of outputPath)
		do shell script "rm " & quoted form of POSIX path of thisFile
	end if
end doPrint

to doPDF(thisFile)
	set theDate to (do shell script "date +%y%m%d%H%M%S")
	set outputName to (theDate & ".pdf") as string
	set deskPosix to POSIX path of (path to desktop folder)
	set outputPath to deskPosix & outputName
	--Sonoma
	try
		do shell script quoted form of gsPosix & space & pageSize & "-sBATCH -dNOPAUSE -sDEVICE=pdfwrite -sOutputFile=" & quoted form of outputPath & space & quoted form of POSIX path of thisFile
	on error err
		display dialog err
	end try
	--Sonoma fix
	-- do shell script ("pstopdf -o " & quoted form of outputPath & space & quoted form of POSIX path of thisFile)
	do shell script "rm " & quoted form of POSIX path of thisFile
end doPDF

to openPDF(thisFile)
	do shell script "rm " & quoted form of POSIX path of thisFile
end openPDF

on doSelect(thisFile)
	set thePrinter to ""
	set theQueue to ""
	-- if doPrinterSetup is 1 then
	set printerNames to (do shell script "SOFTWARE= LANG=C lpstat  -l -p | grep -i Description: |awk -F'Description: ' '{print $2}' ")
	set queueNames to (do shell script "SOFTWARE= LANG=C lpstat -a | awk -F' accepting' '{print $1}'")
	
	set printerList to (every paragraph of printerNames) as list
	set queueList to (every paragraph of queueNames) as list
	
	(*  -- DEBUG
	set removeList to {}
	repeat with i from 1 to count of queueList
		if item i of queueList contains "reason unknown" then
			set removeList to removeList & i
		end if
	end repeat
	set newQueue to {}
	if removeList is not {} then
		repeat with j from 1 to count of queueList
			if j is not in removeList then set end of newQueue to item j of queueList
		end repeat
	end if
	set queueList to newQueue
	*)
	
	if printerList is {} then
		tell application "System Events"
			activate
			-- display dialog "No printer is available." & return & return & "You may use the PDFMAKER macro to create a PDF from this file." buttons {"OK"} with title msgTitle --  giving up after 10
			display dialog "No printer is available." buttons {"OK"} with title msgTitle --  giving up after 10
			try
				set frontmost of process myProc to true
			end try
		end tell
		return
	end if
	
	if the (count of printerList) is 1 then
		set thePrinter to {item 1 of printerList} as string
		set theQueue to {item 1 of queueList} as string
	else
		tell application "SystemUIServer"
			activate
			try
				set thePrinter to (choose from list printerList with title "Printers" with prompt "Select a printer:")
				if thePrinter is false then
					tell application "System Events"
						activate
						display dialog "Printing cancelled." buttons {"OK"} default button 1 with title msgTitle giving up after 10
						try
							set frontmost of process myProc to true
						end try
					end tell
					try
						do shell script "rm" & space & quoted form of POSIX path of thisFile
					on error
						try
							tell application "Finder" to delete thisFile
						end try
					end try
					error number -128
					return
				end if
			on error
				set thePrinter to false
				try
					do shell script "rm" & space & quoted form of POSIX path of thisFile
				on error
					try
						tell application "Finder" to delete thisFile
					end try
				end try
			end try
		end tell
		
		tell application "System Events"
			try
				set frontmost of process myProc to true
			end try
		end tell
		-- removed from previous parenthesis: default items {item 1 of printerList} 
		
		if thePrinter is false then
			tell application "System Events"
				activate
				display dialog "Printing cancelled." buttons {"OK"} default button 1 with title msgTitle giving up after 10
				try
					set frontmost of process myProc to true
				end try
			end tell
			try
				do shell script "rm" & space & quoted form of POSIX path of thisFile
			on error
				try
					tell application "Finder" to delete thisFile
				end try
			end try
			error number -128
			return
		else
			set thePrinter to item 1 of thePrinter
			set item_num to my list_position(thePrinter, printerList)
			set theQueue to item item_num in queueList
			
			-- Sonoma
			try
				do shell script quoted form of gsPosix & space & pageSize & "-sBATCH -dNOPAUSE -sDEVICE=pdfwrite -sOutputFile=" & quoted form of tempPosix & space & quoted form of POSIX path of thisFile
			on error err
				display dialog err
			end try
			
			try
				-- Sonoma
				do shell script "lpr -r -P " & "\"" & theQueue & "\"" & space & quoted form of POSIX path of tempPosix
			on error
				
				tell application "System Events"
					activate
					display dialog "Could not send data file to printer." buttons {"OK"} with title msgTitle giving up after 10
					try
						set frontmost of process myProc to true
					end try
				end tell
			end try
			
			try
				do shell script "rm" & space & quoted form of POSIX path of thisFile
			on error
				try
					tell application "Finder" to delete thisFile
				end try
			end try
			
		end if
		
	end if
	-- end if
end doSelect

on list_position(this_item, this_list)
	repeat with i from 1 to the count of this_list
		if item i of this_list is this_item then return i
	end repeat
	return 0
end list_position
